package kotlinjs.runtime.extension

/**
 * Created by danfm on 16/05/2016.
 */

fun <T> createObjectOf(populate: (T.() -> Unit)? = null): T {
    val obj: T = js("({})")

    if (populate != null) {
        obj.populate()
    }

    return obj
}

fun <TSource, TTarget : TSource> mergeOf(target: TTarget, source: TSource): TTarget {
    val copy: TTarget = createObjectOf()
    js("Object.assign(copy, target, source)")

    return copy
}

fun <TSource, TTarget : TSource> extendObject(source: TSource, populate: TTarget.() -> Unit): TTarget {
    val copy: TTarget = createObjectOf()

    js("Object.assign(copy, source)")
    copy.populate()

    return copy
}

fun <T> createJsonObjectOf(populate: (T.() -> Unit)? = null): Json {
    val obj = createObjectOf(populate)

    return js("(obj)")
}
