package kotlinjs.runtime.extension


/**
 * Created by danfma on 12/05/2016.
 */

inline fun <reified T> typeOf(): Type<T> {
    var type: Type<T>? = null

    js("var tmp = Kotlin.isType; Kotlin.isType = function(a, b) { type = b }")

    null is T

    js("Kotlin.isType = tmp;")

    return type!!
}

@Suppress("unused")
inline fun <reified T> fullNameOf(): String? {
    val f = js("function () { isT(N\$v0 - R0\$iv)}").toString()

    return extractFullName(f)
}

@Suppress("unused")
inline fun <reified T> nameOf(): String? {
    val f = js("function () { isT(N\$v0 - R0\$iv)}").toString()

    return extractSimpleName(f)
}

fun extractFullName(foundTypeName: String): String? {
    val s = "(N\$v0 - R0\$iv, "
    val i = foundTypeName.indexOf(s)
    val e = foundTypeName.lastIndexOf(");")

    if (i == -1 || e == -1)
        return null

    val typeName = foundTypeName.substring(i + s.length, e)

    return if (typeName.startsWith("_.")) typeName.substring(2) else typeName
}

fun extractSimpleName(f: String): String? {
    val name = extractFullName(f)
    val lastDotIndex = name?.lastIndexOf('.') ?: -1

    return if (lastDotIndex > 0) name?.substring(lastDotIndex + 1) else name
}
