package kotlinjs.runtime.promise

/**
 * Created by danfm on 07/05/2016.
 */

@native("Promise")
class Promise<T> {

    @native("then")
    fun <TResult> then(transformer: (T) -> TResult): Promise<TResult>

    @native("then")
    fun <TResult> thenAwait(transformer: (T) -> Promise<TResult>): Promise<TResult>

    @native("catch")
    fun catch(handler: (Error) -> T): Promise<T>

    @native("catch")
    fun <TResult> catchAndMap(handler: (Error) -> TResult): Promise<TResult>

    companion object {
        fun <T> resolve(value: T): Promise<T> = noImpl
    }

}