package react.dom

import react.ReactProps
import react.dom.events.*

/**
 * Created by danfma on 02/06/2016.
 */

@native
interface DOMAttributesBase : ReactProps {
    var className: String?
    var id: String?
    var dangerouslySetInnerHTML: DangerousHtml?

    var onCopy: ((DragEvent) -> Unit)?
    var onCut: ((DragEvent) -> Unit)?
    var onPaste: ((DragEvent) -> Unit)?
    var onKeyDown: ((KeyboardEvent) -> Unit)?
    var onKeyPress: ((KeyboardEvent) -> Unit)?
    var onKeyUp: ((KeyboardEvent) -> Unit)?
    var onFocus: ((FocusEvent) -> Unit)?
    var onBlur: ((FocusEvent) -> Unit)?
    var onChange: ((FormEvent) -> Unit)?
    var onInput: ((FormEvent) -> Unit)?
    var onSubmit: ((FormEvent) -> Unit)?
    var onClick: ((MouseEvent) -> Unit)?
    var onDoubleClick: ((MouseEvent) -> Unit)?
    var onDrag: ((DragEvent) -> Unit)?
    var onDragEnd: ((DragEvent) -> Unit)?
    var onDragEnter: ((DragEvent) -> Unit)?
    var onDragExit: ((DragEvent) -> Unit)?
    var onDragLeave: ((DragEvent) -> Unit)?
    var onDragOver: ((DragEvent) -> Unit)?
    var onDragStart: ((DragEvent) -> Unit)?
    var onDrop: ((DragEvent) -> Unit)?
    var onMouseDown: ((MouseEvent) -> Unit)?
    var onMouseEnter: ((MouseEvent) -> Unit)?
    var onMouseLeave: ((MouseEvent) -> Unit)?
    var onMouseMove: ((MouseEvent) -> Unit)?
    var onMouseOut: ((MouseEvent) -> Unit)?
    var onMouseOver: ((MouseEvent) -> Unit)?
    var onMouseUp: ((MouseEvent) -> Unit)?
    var onTouchCancel: ((TouchEvent) -> Unit)?
    var onTouchEnd: ((TouchEvent) -> Unit)?
    var onTouchMove: ((TouchEvent) -> Unit)?
    var onTouchStart: ((TouchEvent) -> Unit)?
    var onScroll: ((UIEvent) -> Unit)?
    var onWheel: ((WheelEvent) -> Unit)?

}