package react.core

import react.ReactModule
import react.ReactProps

/**
 * Created by danfma on 10/05/16.
 */

fun <T : Component<*, *>> ReactModule.createElement(factory: ComponentFactory<T>, props: ReactProps?, vararg children: Any?): TypedReactElement<T> {
    return this.createElement(factory.type, props, *children)
}


inline fun <reified T : Component<*, *>> namedFactoryOf(displayName: String): ComponentFactory<T> {
    return ComponentFactory(T::class.js).apply {
        this.displayName = displayName
    }
}

inline fun <reified T : Component<*, *>> factoryOf(): ComponentFactory<T> {
    return ComponentFactory(T::class.js)
}
