package react.core

class ComponentFactory<T : Component<*, *>>(val type: JsClass<T>) {
    private val dynamicType: dynamic
        get() = type.asDynamic()

    var displayName: String?
        get() {
            return dynamicType.displayName
        }
        set(value) {
            dynamicType.displayName = value
        }

    var propTypes: PropTypeDefinition?
        get() {
            return dynamicType.propTypes
        }
        set(value) {
            dynamicType.propTypes = value
        }

}