package react

import kotlinjs.runtime.commonjs.requireModuleAndReturn
import org.w3c.dom.Element
import react.core.Component
import react.core.ReactElement
import react.core.TypedReactElement


interface ReactDOMModule {

    @native("render")
    fun render(element: ReactElement, container: Element): Component<*, *> = noImpl

    @native("render")
    fun <T : Component<*, *>> render(element: TypedReactElement<T>, container: Element): T = noImpl

}

val ReactDOM = requireModuleAndReturn<ReactDOMModule>("react-dom")
