package react.core

import kotlinjs.runtime.JsType

class ComponentFactory<T : Component<*, *>>(val type: JsType<T>) {

    var displayName: String?
        get() {
            return type["displayName"] as String?
        }
        set(value) {
            type["displayName"] = value
        }

    var propTypes: PropTypeDefinition?
        get() {
            return type["propTypes"] as PropTypeDefinition?
        }
        set(value) {
            type["propTypes"] = value
        }

}