package react.dom

// This @native interface is not complete. Only properties accepting
// unitless Numbers are listed here (see CSSProperty.js in React)
@native
interface CSSProperties {
    var boxFlex: Number?
    var boxFlexGroup: Number?
    var columnCount: Number?

    @native("flex")
    var flex: String?

    @native("flex")
    var flexValue: Number?

    var flexGrow: Number?
    var flexShrink: Number?

    @native("fontWeight")
    var fontWeight: Number?

    @native("fontWeight")
    var fontWeightWithUnit: String?

    var lineClamp: Number?

    @native("lineHeight")
    var lineHeight: Number?

    @native("lineHeight")
    var lineHeightWithUnit: String?

    var opacity: Number?
    var order: Number?
    var orphans: Number?
    var widows: Number?
    var zIndex: Number?
    var zoom: Number?

    @native("fontSize")
    var fontSize: Number?

    @native("fontSize")
    var fontSizeWithUnit: String?

    // SVG-related properties
    var fillOpacity: Number?
    var strokeOpacity: Number?
    var strokeWidth: Number?

    @nativeGetter
    operator fun get(propertyName: String): Any?

    @nativeSetter
    operator fun set(propertyName: String, value: Any?)
}