package react

import kotlinjs.runtime.JsType
import kotlinjs.runtime.cjs.requireModule
import react.core.Component
import react.core.ReactElement
import react.core.ReakoPropTypes
import react.core.TypedReactElement


@native
interface ReactModule {

    @native("PropTypes")
    val propTypes: ReakoPropTypes

    @native("createElement")
    fun createElement(elementName: String, props: ReactProps?, vararg children: Any?): ReactElement = noImpl

    @native("createElement")
    fun <T : Component<*, *>> createElement(componentType: JsType<T>, props: ReactProps?, vararg children: Any?): TypedReactElement<T> = noImpl

}


val React = requireModule<ReactModule>("react")
