package react

import kotlinjs.runtime.extension.createObjectOf
import kotlinjs.runtime.extension.mergeOf
import react.core.Component
import react.core.ComponentFactory
import react.core.ReactElement

fun <T : ReactProps> emptyPropsOf(): T = js("({})")


fun ksx(populate: ReactProps.() -> Unit): ReactElement? {
    val props = emptyPropsOf<ReactProps>()

    props.populate()

    val builder = object : KsxBuilderNode<ReactProps>(props) {
        override fun build(): ReactElement? {
            val childrenCount = p.children?.size ?: 0

            if (childrenCount > 1) {
                console.error("Root Components should have at most one child")
            }

            return toReactElement(p.children?.firstOrNull())
        }
    }

    return builder.build()
}

fun toReactElement(child: Any?): ReactElement? {
    return when (child) {
        is KsxBuilder -> child.build()
        else -> raw(child)
    }
}

@Suppress("UNUSED_PARAMETER")
fun raw(something: Any?): ReactElement? = js("(something)")

fun ReactProps.append(children: Any?) {
    var currentChildren = this.children ?: arrayOf()

    // HACK kotlin Array.plus operator is not working
    @Suppress("UNUSED_PARAMETER")
    fun concat(a: Array<Any?>, b: Array<Any?>): Array<Any?> = js("a.concat(b)")

    when (children) {
        is Array<*> -> {
            currentChildren = concat(currentChildren, children.map { toReactElement(it) }.toTypedArray())
        }

        else -> {
            currentChildren = concat(currentChildren, arrayOf(toReactElement(children)))
        }
    }

    this.children = currentChildren
}

val ReactProps.inlineText: (() -> String?) -> Unit
    get() = { text ->
        append(raw(text()))
    }


fun <TComponent : Component<TProps, *>, TProps : ReactProps> builderOf(
        factory: ComponentFactory<TComponent>,
        parent: ReactProps): ReactBuilder<TComponent, TProps> {

    return object : ReactBuilder<TComponent, TProps>(factory, createObjectOf<TProps>()) {
        override fun postInvoke() {
            super.postInvoke()
            parent.append(this)
        }
    }
}

fun <TProps : ReactProps> builderOf(
        builder: KsxBuilderNode<TProps>,
        parent: ReactProps): KsxBuilderNode<TProps> {

    return object : KsxBuilderNode<TProps>(builder.p) {
        override fun build(): ReactElement? {
            return builder.build()
        }

        override fun postInvoke() {
            super.postInvoke()
            parent.append(this)
        }
    }
}

@Suppress("UNUSED_PARAMETER", "UNUSED_VARIABLE")
fun <T : ReactProps> T.copyFrom(other: T) {
    val self = this

    js("""
        for (var key in other) {
            self[key] = other[key];
        }
    """)
}

fun ReactProps.propsFrom(other: ReactProps) {
    mergeOf(this, other)
}

