package react

import kotlinjs.runtime.commonjs.requireModuleAndReturn
import kotlinjs.runtime.extension.Type
import react.core.Component
import react.core.ReactElement
import react.core.ReakoPropTypes
import react.core.TypedReactElement


@native
interface ReactModule {

    @native("PropTypes")
    val propTypes: ReakoPropTypes;

    @native("createElement")
    fun createElement(elementName: String, props: ReactProps?, vararg children: Any?): ReactElement = noImpl;

    @native("createElement")
    fun <T : Component<*, *>> createElement(componentType: Type<T>, props: ReactProps?, vararg children: Any?): TypedReactElement<T> = noImpl;

}


val React: ReactModule = requireModuleAndReturn("react")
