package react

import react.core.ComponentFactory
import react.core.ReactElement
import react.core.React
import react.core.Component

abstract class ReactBuilder<TComponent : Component<TProps, *>, TProps : ReactProps>(
        val factory: ComponentFactory<TComponent>,
        override val p: TProps) : KsxBuilderNode<TProps>(p) {

    override fun build(): ReactElement? {
        return React.createElement(factory.type, p)
    }

}

