package react.dom

import kotlinjs.runtime.extension.createObjectOf
import react.KsxBuilderNode
import react.core.React
import react.core.ReactElement

abstract class HTMLElementTagBuilder<TProps : HTMLElementAttributes>(
        val tagName: String,
        override val p: TProps = createObjectOf()) : KsxBuilderNode<TProps>(p), HTMLElementAttributes by p {

    override fun build(): ReactElement? {
        return React.createElement(tagName, p)
    }

}
