package react.util

import kotlinjs.runtime.extension.createObjectOf
import react.core.Component
import react.core.ComponentFactory
import react.core.PropTypeDefinition
import react.core.React

class PropTypeBuilder<T : Component<TProps, *>, TProps> {
    val restrictions = hashMapOf<String, (props: Json, propName: String, componentName: String) -> Error?>()

    private fun memberOf(selector: (TProps) -> Any?): String {
        val regex = Regex("""it\.(.*);""")
        val result = regex.find(selector.toString()) ?: throw Error("Defina a seleção do membro usando uma expressão simples com o parâmetro 'it'.")

        return result.groupValues[1]
    }

    fun <TProperty> required(selector: (TProps) -> TProperty) {
        val memberName = memberOf(selector)
        val restriction = React.propTypes.forAny.isRequired

        restrictions.put(memberName, restriction)
    }

    fun applyTo(factory: ComponentFactory<T>) {
        val props = createObjectOf<PropTypeDefinition>()

        for (entry in restrictions) {
            props[entry.key] = entry.value
        }

        factory.propTypes = props
    }

}