package react.core

@native("React.Component")
abstract class Component<Props, State> {
    @native
    val props: Props = noImpl;

    @native
    var state: State = noImpl;

    @native
    val refs: ElementRefs = noImpl;

    @native("setState")
    protected fun setState(state: State): Unit = noImpl;

    @native("setState")
    protected fun setState(state: State, callback: () -> Unit): Unit = noImpl;

    @native
    fun forceUpdate(): Unit = noImpl

    @native("render")
    abstract fun render(): ReactElement?;
}