package react.dom

import kotlinjs.runtime.extension.createObjectOf
import react.KsxBuilderNode
import react.ReactProps
import react.append

/**
 * Created by danfma on 06/05/2016.
 */

fun defineStyle(populate: ReactStyleSheet.() -> Unit): ReactStyleSheet {
    val style = createObjectOf<ReactStyleSheet>()
    style.populate()

    return style
}

fun <TProps : HtmlNodeProps> builderOf(
        tagName: String,
        parent: ReactProps): ReactHtmlNodeBuilder<TProps> {

    return object : ReactHtmlNodeBuilder<TProps>(tagName) {
        override fun postInvoke() {
            parent.append(this)
        }
    }
}


// A GENERATOR WILL BE GOOD HERE!

val ReactProps.div: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("div", this)

val ReactProps.span: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("span", this)

val ReactProps.h1: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("h1", this)

val ReactProps.h2: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("h2", this)

val ReactProps.h3: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("h3", this)

val ReactProps.h4: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("h4", this)

val ReactProps.h5: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("h5", this)

val ReactProps.h6: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("h6", this)

val ReactProps.a: KsxBuilderNode<HtmlLinkElementProps>
    get() = builderOf("a", this)

val ReactProps.i: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("i", this)

val ReactProps.label: KsxBuilderNode<HtmlNodeProps>
    get() = builderOf("label", this)

val ReactProps.img: KsxBuilderNode<HtmlImageProps>
    get() = builderOf("img", this)

val ReactProps.form: KsxBuilderNode<HtmlFormProps>
    get() = builderOf("form", this)

val ReactProps.input: KsxBuilderNode<HtmlInputElementProps>
    get() = builderOf("input", this)

val ReactProps.button: KsxBuilderNode<HtmlButtonProps>
    get() = builderOf("button", this)

