package react.dom

import kotlinjs.runtime.extension.createObjectOf
import react.KsxBuilderNode
import react.core.React
import react.core.ReactElement

abstract class ReactHtmlNodeBuilder<TProps : HtmlNodeProps>(
        val tagName: String,
        override val p: TProps = createObjectOf()) : KsxBuilderNode<TProps>(p), HtmlNodeProps by p {

    override fun build(): ReactElement? {
        return React.createElement(tagName, p)
    }

}
