package react.core

import kotlinjs.runtime.extension.typeOf
import react.ReactProps

/**
 * Created by danfma on 10/05/16.
 */

fun <T : Component<*, *>> React.createElement(factory: ComponentFactory<T>, props: ReactProps?, vararg children: Any?): TypedReactElement<T> {
    return this.createElement(factory.type, props, *children)
}


inline fun <reified T : Component<*, *>> namedFactoryOf(displayName: String): ComponentFactory<T> {
    val type = typeOf<T>()

    type["displayName"] = displayName

    return ComponentFactory(type).apply {
        this.displayName = displayName
    }
}
