package react.router

import kotlinjs.runtime.extension.createObjectOf
import org.w3c.dom.History
import react.React
import react.core.ReactElement


interface RouterProps : RoutingProps {
    var history: History
}

fun router(history: History, populate: RouterProps.() -> Unit): ReactElement {
    val props = createObjectOf<RouterProps> {
        this.history = history
        children = arrayOf()
    }

    props.populate()

    return React.createElement(ReactRouter.Router, props)
}
