package react.router

import kotlinjs.runtime.JsType
import kotlinjs.runtime.extension.createObjectOf
import react.React
import react.core.Component
import react.core.ComponentFactory

/**
 * Created by danfma on 07/05/2016.
 */

interface RouteProps : RoutingProps {
    var path: String
    var component: JsType<out Component<*, *>>
}

fun RoutingProps.route(path: String, componentFactory: ComponentFactory<*>, populate: RouteProps.() -> Unit) {
    val props = createObjectOf<RouteProps> {
        this.path = path
        this.component = componentFactory.type
    }

    props.populate()

    val routeElement = React.createElement(ReactRouter.Route, props)

    children = (children ?: arrayOf()) + routeElement
}

fun RoutingProps.route(path: String, componentFactory: ComponentFactory<*>) {
    val props = createObjectOf<RouteProps> {
        this.path = path
        this.component = componentFactory.type
    }

    val routeElement = React.createElement(ReactRouter.Route, props)

    children = (children ?: arrayOf()) + routeElement
}