@file:Suppress("UNUSED_PARAMETER", "UNUSED_VARIABLE")

package react.router

import kotlinjs.runtime.JsType
import kotlinjs.runtime.extension.createObjectOf
import react.React
import react.ReactProps
import react.core.Component
import react.core.ComponentFactory

/**
 * Created by danfma on 06/05/2016.
 */


interface IndexRouteProps : ReactProps {
    var component: JsType<out Component<*, *>>
}

fun RoutingProps.indexRoute(componentFactory: ComponentFactory<*>) {
    val props = createObjectOf<IndexRouteProps> {
        this.component = componentFactory.type
    }

    val routeElement = React.createElement(ReactRouter.IndexRoute, props)

    children = (children ?: arrayOf()) + routeElement
}
