(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'react'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('react'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kodando-react'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kodando-react'.");
    }
    if (typeof React === 'undefined') {
      throw new Error("Error loading module 'kodando-react'. Its dependency 'react' was not found. Please, check whether 'react' is loaded prior to 'kodando-react'.");
    }
    root['kodando-react'] = factory(typeof this['kodando-react'] === 'undefined' ? {} : this['kodando-react'], kotlin, React);
  }
}(this, function (_, Kotlin, $module$react) {
  'use strict';
  var $$importsForInline$$ = _.$$importsForInline$$ || (_.$$importsForInline$$ = {});
  var defineInlineFunction = Kotlin.defineInlineFunction;
  var firstOrNull = Kotlin.kotlin.collections.firstOrNull_us0mfu$;
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var joinToString = Kotlin.kotlin.collections.joinToString_cgipc5$;
  var createProps = defineInlineFunction('kodando-react.kodando.react.createProps', function () {
    return {children: []};
  });
  var createProps_0 = defineInlineFunction('kodando-react.kodando.react.createPropsAndConfigure', function (configure) {
    var $receiver = {children: []};
    configure($receiver);
    return $receiver;
  });
  function configureBy($receiver, configure) {
    if (configure != null) {
      configure($receiver);
    }
    return $receiver;
  }
  function asReactChildren(child) {
    return child;
  }
  function addChild(target, child) {
    var children = target.children;
    if (Kotlin.equals(children, undefined)) {
      target.children = child;
    }
     else if (Kotlin.isArray(children)) {
      target.children = children.concat([child]);
    }
     else {
      target.children = [children, child];
    }
  }
  var noChildren;
  function extractChildren(props) {
    var tmp$;
    var children = props.children;
    delete props.children;
    if (Kotlin.equals(children, undefined))
      tmp$ = noChildren;
    else if (Kotlin.isArray(children)) {
      tmp$ = children;
    }
     else
      tmp$ = [children];
    return tmp$;
  }
  function createElement(tagName, props) {
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [tagName, props].concat(extractChildren(props)));
  }
  function createComponent(componentType, props) {
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [componentType, props].concat(extractChildren(props)));
  }
  function root(configure) {
    var $receiver = {children: []};
    configure($receiver);
    return firstChild($receiver);
  }
  function firstChild($receiver) {
    var tmp$;
    var children = $receiver.children;
    if (Kotlin.equals(children, undefined) || children == null)
      tmp$ = null;
    else if (Kotlin.isArray(children)) {
      tmp$ = firstOrNull(children);
    }
     else {
      tmp$ = children;
    }
    return tmp$;
  }
  function add($receiver, child) {
    addChild($receiver, child);
  }
  function add_0($receiver, text) {
    addChild($receiver, text);
  }
  function add_1($receiver, number) {
    addChild($receiver, number);
  }
  function add_2($receiver, children) {
    addChild($receiver, children);
  }
  function add_3($receiver, children) {
    addChild($receiver, children);
  }
  function addComponent($receiver, componentType, props, configure) {
    if (props === void 0) {
      props = {children: []};
    }
    if (configure === void 0)
      configure = null;
    if (configure != null) {
      configure(props);
    }
    addChild($receiver, createComponent(componentType, props));
  }
  function addComponent_0($receiver, componentType, props, configure) {
    if (props === void 0) {
      props = {children: []};
    }
    if (configure === void 0)
      configure = null;
    addComponent($receiver, get_js(componentType), props, configure);
  }
  function ReactChildren() {
  }
  ReactChildren.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ReactChildren',
    interfaces: []
  };
  var ArrayList_init = Kotlin.kotlin.collections.ArrayList_init_ww73n8$;
  function StyleBuilder(initialClasses) {
    this.classes = ArrayList_init();
    var tmp$;
    for (tmp$ = 0; tmp$ !== initialClasses.length; ++tmp$) {
      var element = initialClasses[tmp$];
      this.add_pdl1vj$(element);
    }
  }
  StyleBuilder.prototype.add_pdl1vj$ = function (className) {
    if (className != null) {
      this.classes.add_11rb$(className);
    }
    return this;
  };
  StyleBuilder.prototype.add_154u1l$ = function (className, predicate) {
    if (predicate === true) {
      this.add_pdl1vj$(className);
    }
    return this;
  };
  var copyToArray = Kotlin.kotlin.collections.copyToArray;
  StyleBuilder.prototype.toString = function () {
    return joinToString(copyToArray(this.classes), ' ');
  };
  StyleBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'StyleBuilder',
    interfaces: []
  };
  var package$kodando = _.kodando || (_.kodando = {});
  var package$react = package$kodando.react || (package$kodando.react = {});
  package$react.createProps = createProps;
  $$importsForInline$$['kodando-react'] = _;
  package$react.createPropsAndConfigure = createProps_0;
  package$react.configureBy = configureBy;
  package$react.addChild = addChild;
  package$react.createElement = createElement;
  package$react.createComponent = createComponent;
  package$react.root = root;
  package$react.firstChild = firstChild;
  package$react.addNode = add;
  package$react.addText = add_0;
  package$react.addNumber = add_1;
  package$react.addNodes = add_2;
  package$react.addChildren = add_3;
  package$react.addComponent = addComponent;
  package$react.addKComponent = addComponent_0;
  package$react.ReactChildren = ReactChildren;
  var package$util = package$react.util || (package$react.util = {});
  package$util.StyleBuilder = StyleBuilder;
  noChildren = [];
  Kotlin.defineModule('kodando-react', _);
  return _;
}));

//# sourceMappingURL=kodando-react.js.map
