(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define('kodando-react', ['exports', 'kotlin', 'react'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('react'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kodando-react'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kodando-react'.");
    }
    if (typeof React === 'undefined') {
      throw new Error("Error loading module 'kodando-react'. Its dependency 'react' was not found. Please, check whether 'react' is loaded prior to 'kodando-react'.");
    }
    root['kodando-react'] = factory(typeof this['kodando-react'] === 'undefined' ? {} : this['kodando-react'], kotlin, React);
  }
}(this, function (_, Kotlin, $module$react) {
  'use strict';
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var Regex = Kotlin.kotlin.text.Regex_61zpoe$;
  var Error_0 = Kotlin.kotlin.Error;
  var joinToString = Kotlin.kotlin.collections.joinToString_cgipc5$;
  var to = Kotlin.kotlin.to_ujzrz7$;
  ComponentBuilder.prototype = Object.create(ElementBuilder.prototype);
  ComponentBuilder.prototype.constructor = ComponentBuilder;
  ksx.prototype = Object.create(ElementBuilder.prototype);
  ksx.prototype.constructor = ksx;
  function BaseProps() {
  }
  BaseProps.prototype.get = function (propertyName) {
    return this[propertyName];
  };
  BaseProps.prototype.set = function (propertyName, value) {
    this[propertyName] = value;
  };
  BaseProps.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'BaseProps',
    interfaces: [ReactProps]
  };
  function ComponentBuilder(componentType) {
    ElementBuilder.call(this);
    this.componentType = componentType;
  }
  ComponentBuilder.prototype.invoke_oswy3$ = function (propsSetter) {
    var tmp$_0;
    var tmp$ = extractChildren(unsafePropsBy(propsSetter))
    , children = tmp$.component1()
    , props = tmp$.component2();
    return (tmp$_0 = $module$react).createElement.apply(tmp$_0, [this.componentType, props].concat(children));
  };
  ComponentBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ComponentBuilder',
    interfaces: [ElementBuilder]
  };
  function ComponentBuilder_init(componentType, $this) {
    $this = $this || Object.create(ComponentBuilder.prototype);
    ComponentBuilder.call($this, get_js(componentType));
    return $this;
  }
  function makeComponent$lambda(closure$renderer, closure$propSetter) {
    return function (setter) {
      return $module$react.createElement(closure$renderer, closure$propSetter(setter));
    };
  }
  function makeComponent(name, propFactory, renderer) {
    renderer['displayName'] = name;
    var propSetter = propSetterOf(propFactory);
    return makeComponent$lambda(renderer, propSetter);
  }
  function ElementBuilder() {
  }
  ElementBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ElementBuilder',
    interfaces: []
  };
  function createElement($receiver, factory, props, children) {
    var tmp$;
    return (tmp$ = $receiver).createElement.apply(tmp$, [factory, props].concat(children));
  }
  function append($receiver, children) {
    var tmp$, tmp$_0;
    var currentChildren = (tmp$_0 = (tmp$ = $receiver.children) != null ? toArray(tmp$) : null) != null ? tmp$_0 : [];
    currentChildren = currentChildren.concat([children]);
    $receiver.children = asReactChildren(currentChildren);
  }
  function get_addText$lambda(this$addText) {
    return function (text_0) {
      append(this$addText, raw(text_0()));
    };
  }
  function get_addText($receiver) {
    return get_addText$lambda($receiver);
  }
  function addText($receiver, text_0) {
    append($receiver, raw(text_0));
  }
  function spread($receiver, other, except) {
    if (except === void 0)
      except = null;
    var self_0 = $receiver;
    var exception = (except || []).reduce(function (acc, x) {
      acc[x] = true;
      return acc;
    }, {});
    for (var key in other) {
      if (exception[key]) {
        continue;
      }
      self_0[key] = other[key];
    }
  }
  function ksx() {
    ksx_instance = this;
    ElementBuilder.call(this);
  }
  ksx.prototype.invoke_oswy3$ = function (propsSetter) {
    var props = unsafePropsBy(propsSetter);
    var children = props.children;
    return childrenAsElement(children);
  };
  ksx.$metadata$ = {
    kind: Kotlin.Kind.OBJECT,
    simpleName: 'ksx',
    interfaces: [ElementBuilder]
  };
  var ksx_instance = null;
  function ksx_getInstance() {
    if (ksx_instance === null) {
      new ksx();
    }
    return ksx_instance;
  }
  function objectWithShapeOf() {
    return {};
  }
  function objectWithShapeBy(setter) {
    var obj = objectWithShapeOf();
    setter(obj);
    return obj;
  }
  function unsafePropsOf() {
    return new BaseProps();
  }
  function unsafePropsBy(setter) {
    var $receiver = unsafePropsOf();
    setter($receiver);
    return $receiver;
  }
  function propsBy(factory, setter) {
    var $receiver = factory();
    setter($receiver);
    return $receiver;
  }
  function propSetterOf$lambda(closure$factory) {
    return function (setter) {
      var $receiver = closure$factory();
      setter($receiver);
      return $receiver;
    };
  }
  function propSetterOf(factory) {
    return propSetterOf$lambda(factory);
  }
  function toPropSetter$lambda(this$toPropSetter) {
    return function (setter) {
      var $receiver = this$toPropSetter();
      setter($receiver);
      return $receiver;
    };
  }
  function toPropSetter($receiver) {
    return toPropSetter$lambda($receiver);
  }
  function PropTypeBuilder() {
    this.restrictions = Kotlin.kotlin.collections.HashMap_init_q3lmfv$();
  }
  PropTypeBuilder.prototype.memberOf_0 = function (selector) {
    var tmp$;
    var regex = Regex('it\\.(.*);');
    tmp$ = regex.find_905azu$(selector.toString());
    if (tmp$ == null) {
      throw new Error_0("Defina a sele\xE7\xE3o do membro usando uma express\xE3o simples com o par\xE2metro 'it'.");
    }
    var result = tmp$;
    return result.groupValues.get_za3lpa$(1);
  };
  PropTypeBuilder.prototype.required_r1ursk$ = function (selector) {
    var memberName = this.memberOf_0(selector);
    var restriction = $module$react.PropTypes.any.isRequired;
    this.restrictions.put_xwzc9p$(memberName, restriction);
  };
  PropTypeBuilder.prototype.applyTo_4xyc12$ = function (factory) {
    var tmp$_0;
    var props = objectWithShapeOf();
    tmp$_0 = this.restrictions.entries.iterator();
    while (tmp$_0.hasNext()) {
      var tmp$ = tmp$_0.next();
      var key = tmp$.key;
      var value = tmp$.value;
      props.set(key, value);
    }
    factory.propTypes = props;
  };
  PropTypeBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropTypeBuilder',
    interfaces: []
  };
  function propTypesOf(factory, configure) {
    var propTypeBuilder = new PropTypeBuilder();
    configure(propTypeBuilder);
    propTypeBuilder.applyTo_4xyc12$(factory);
  }
  function ReactChildren() {
  }
  ReactChildren.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ReactChildren',
    interfaces: []
  };
  function isArray($receiver) {
    return Array.isArray($receiver);
  }
  function hasSingleElement($receiver) {
    return $receiver.length === 1;
  }
  function isString($receiver) {
    return typeof $receiver === 'string';
  }
  function isNumber($receiver) {
    return typeof $receiver === 'number';
  }
  function isElement($receiver) {
    return typeof $receiver === 'object';
  }
  function toArray($receiver) {
    return isArray($receiver) ? $receiver : [$receiver];
  }
  function asReactChildren(data) {
    return data;
  }
  function ReactProps() {
  }
  ReactProps.prototype.unaryPlus_wsm53i$ = function ($receiver) {
    append(this, $receiver);
  };
  ReactProps.prototype.unaryPlus_5cw0du$ = function ($receiver) {
    append(this, $receiver);
  };
  ReactProps.prototype.unaryPlus_91d72v$ = function ($receiver) {
    append(this, $receiver);
  };
  ReactProps.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ReactProps',
    interfaces: []
  };
  var get_key = Kotlin.defineInlineFunction('kodando-react.kodando.react.get_key_tpwajr$', function ($receiver) {
    return $receiver.key;
  });
  var set_key = Kotlin.defineInlineFunction('kodando-react.kodando.react.set_key_jjjw2i$', function ($receiver, value) {
    $receiver.key = value;
  });
  var get_ref = Kotlin.defineInlineFunction('kodando-react.kodando.react.get_ref_tpwajr$', function ($receiver) {
    return $receiver.ref;
  });
  var set_ref = Kotlin.defineInlineFunction('kodando-react.kodando.react.set_ref_jjjw2i$', function ($receiver, value) {
    $receiver.ref = value;
  });
  function get_refBy($receiver) {
    return $receiver.ref;
  }
  function set_refBy($receiver, value) {
    $receiver.ref = value;
  }
  var get_children = Kotlin.defineInlineFunction('kodando-react.kodando.react.get_children_tpwajr$', function ($receiver) {
    return $receiver.children;
  });
  var set_children = Kotlin.defineInlineFunction('kodando-react.kodando.react.set_children_3iyuw1$', function ($receiver, value) {
    $receiver.children = value;
  });
  function StatelessRenderer(factory) {
    var tmp$;
    this.renderer_nk0uia$_0 = makeComponent((tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE(), factory, Kotlin.getCallableRef('render', function ($receiver, props) {
      return $receiver.render_dsua73$(props);
    }.bind(null, this)));
  }
  StatelessRenderer.prototype.invoke_i6iysw$ = function (setter) {
    return this.renderer_nk0uia$_0(setter);
  };
  StatelessRenderer.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'StatelessRenderer',
    interfaces: []
  };
  function StyleBuilder(initialClasses) {
    this.classes = Kotlin.kotlin.collections.ArrayList_init_ww73n8$();
    var tmp$;
    for (tmp$ = 0; tmp$ !== initialClasses.length; ++tmp$) {
      var element = initialClasses[tmp$];
      this.add_pdl1vj$(element);
    }
  }
  StyleBuilder.prototype.add_pdl1vj$ = function (className) {
    if (className != null) {
      this.classes.add_11rb$(className);
    }
    return this;
  };
  StyleBuilder.prototype.add_154u1l$ = function (className, predicate) {
    if (Kotlin.equals(predicate, true)) {
      this.add_pdl1vj$(className);
    }
    return this;
  };
  StyleBuilder.prototype.toString = function () {
    var $receiver = this.classes;
    return joinToString(Kotlin.kotlin.collections.copyToArray($receiver), ' ');
  };
  StyleBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'StyleBuilder',
    interfaces: []
  };
  function extractChildren(props) {
    var tmp$;
    tmp$ = props.children;
    if (tmp$ == null) {
      return to([], props);
    }
    var children = tmp$;
    var property = Kotlin.getPropertyCallableRef('children', 0, function ($receiver) {
      return get_children($receiver);
    }.bind(null, props), function ($receiver, value) {
      set_children($receiver, value);
    }.bind(null, props));
    deleteFrom(props, property);
    return to(toArray(children), props);
  }
  function deleteFrom(props, property) {
    delete props[property.name];
  }
  function childrenAsElement(children) {
    if (children == null) {
      return null;
    }
     else if (Array.isArray(children)) {
      return raw(children[0]);
    }
     else {
      return raw(children);
    }
  }
  function raw(something) {
    return something;
  }
  BaseProps.prototype.unaryPlus_wsm53i$ = ReactProps.prototype.unaryPlus_wsm53i$;
  BaseProps.prototype.unaryPlus_5cw0du$ = ReactProps.prototype.unaryPlus_5cw0du$;
  BaseProps.prototype.unaryPlus_91d72v$ = ReactProps.prototype.unaryPlus_91d72v$;
  var package$kodando = _.kodando || (_.kodando = {});
  var package$react = package$kodando.react || (package$kodando.react = {});
  package$react.BaseProps = BaseProps;
  package$react.ComponentBuilder_init_t2dy1h$ = ComponentBuilder_init;
  package$react.ComponentBuilder = ComponentBuilder;
  package$react.makeComponent_wim61n$ = makeComponent;
  package$react.ElementBuilder = ElementBuilder;
  package$react.createElement_g2tv4o$ = createElement;
  package$react.append_poknt3$ = append;
  package$react.get_addText_tpwajr$ = get_addText;
  package$react.addText_jjjw2i$ = addText;
  package$react.spread_wdbsdg$ = spread;
  Object.defineProperty(package$react, 'ksx', {
    get: ksx_getInstance
  });
  package$react.objectWithShapeOf_287e2$ = objectWithShapeOf;
  package$react.objectWithShapeBy_7qq44f$ = objectWithShapeBy;
  package$react.unsafePropsOf_ytx7zy$ = unsafePropsOf;
  package$react.unsafePropsBy_qa7hpv$ = unsafePropsBy;
  package$react.propsBy = propsBy;
  package$react.propSetterOf = propSetterOf;
  package$react.toPropSetter = toPropSetter;
  package$react.PropTypeBuilder = PropTypeBuilder;
  package$react.propTypesOf_7ax5qd$ = propTypesOf;
  package$react.ReactChildren = ReactChildren;
  package$react.isArray_u2tzwq$ = isArray;
  package$react.hasSingleElement_u2tzwq$ = hasSingleElement;
  package$react.isString_u2tzwq$ = isString;
  package$react.isNumber_u2tzwq$ = isNumber;
  package$react.isElement_u2tzwq$ = isElement;
  package$react.toArray_u2tzwq$ = toArray;
  package$react.asReactChildren_eg9ycu$ = asReactChildren;
  package$react.ReactProps = ReactProps;
  package$react.get_key_tpwajr$ = get_key;
  package$react.set_key_jjjw2i$ = set_key;
  package$react.get_ref_tpwajr$ = get_ref;
  package$react.set_ref_jjjw2i$ = set_ref;
  package$react.get_refBy_tpwajr$ = get_refBy;
  package$react.set_refBy_usxg4r$ = set_refBy;
  package$react.get_children_tpwajr$ = get_children;
  package$react.set_children_3iyuw1$ = set_children;
  package$react.StatelessRenderer = StatelessRenderer;
  package$react.StyleBuilder = StyleBuilder;
  package$react.extractChildren_9tz718$ = extractChildren;
  package$react.raw_s8jyv4$ = raw;
  Kotlin.defineModule('kodando-react', _);
  return _;
}));

//@ sourceMappingURL=kodando-react.js.map
