(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define('kodando-react', ['exports', 'kotlin', 'react'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('react'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'kodando-react'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'kodando-react'.");
    }
    if (typeof React === 'undefined') {
      throw new Error("Error loading module 'kodando-react'. Its dependency 'react' was not found. Please, check whether 'react' is loaded prior to 'kodando-react'.");
    }
    root['kodando-react'] = factory(typeof this['kodando-react'] === 'undefined' ? {} : this['kodando-react'], kotlin, React);
  }
}(this, function (_, Kotlin, $module$react) {
  'use strict';
  var get_js = Kotlin.kotlin.js.get_js_1yb8b7$;
  var ReadWriteProperty = Kotlin.kotlin.properties.ReadWriteProperty;
  var Regex = Kotlin.kotlin.text.Regex_61zpoe$;
  var Error_0 = Kotlin.kotlin.Error;
  var Throwable = Error;
  var json = Kotlin.kotlin.js.json_pyyo18$;
  var joinToString = Kotlin.kotlin.collections.joinToString_cgipc5$;
  OnlyOneChildIsAllowedError.prototype = Object.create(Throwable.prototype);
  OnlyOneChildIsAllowedError.prototype.constructor = OnlyOneChildIsAllowedError;
  function ComponentBuilder(componentType, propsFactory) {
    if (propsFactory === void 0)
      propsFactory = ComponentBuilder_init$lambda;
    this.componentType = componentType;
    this.propsFactory = propsFactory;
  }
  ComponentBuilder.prototype.invoke_oswy3$ = function (propsSetter) {
    var tmp$ = this.componentType;
    var $receiver = this.propsFactory();
    propsSetter($receiver);
    return createElement(tmp$, $receiver, []);
  };
  function ComponentBuilder_init$lambda() {
    return unsafePropsOf();
  }
  ComponentBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ComponentBuilder',
    interfaces: []
  };
  function ComponentBuilder_init(componentType, propsFactory, $this) {
    if (propsFactory === void 0)
      propsFactory = ComponentBuilder_init$lambda_0;
    $this = $this || Object.create(ComponentBuilder.prototype);
    ComponentBuilder.call($this, get_js(componentType), propsFactory);
    return $this;
  }
  function ComponentBuilder_init$lambda_0() {
    return unsafePropsOf();
  }
  function JsonPropertyDelegate(json_0, customProperty) {
    if (customProperty === void 0)
      customProperty = null;
    this.json = json_0;
    this.customProperty = customProperty;
  }
  JsonPropertyDelegate.prototype.getValue_lrcp0p$ = function (thisRef, property) {
    var tmp$;
    return this.json[(tmp$ = this.customProperty) != null ? tmp$ : property.callableName];
  };
  JsonPropertyDelegate.prototype.setValue_9rddgb$ = function (thisRef, property, value) {
    var tmp$;
    this.json[(tmp$ = this.customProperty) != null ? tmp$ : property.callableName] = value;
  };
  JsonPropertyDelegate.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'JsonPropertyDelegate',
    interfaces: [ReadWriteProperty]
  };
  function makeNamedComponent$lambda(closure$propSetter, closure$renderer) {
    return function (setter) {
      var props = closure$propSetter(setter);
      return createElement_0(closure$renderer, props, []);
    };
  }
  function makeNamedComponent(name, propFactory, renderer) {
    renderer['displayName'] = name;
    var propSetter = propSetterOf(propFactory);
    return makeNamedComponent$lambda(propSetter, renderer);
  }
  function objectWithShapeOf() {
    return {};
  }
  function objectWithShapeBy(setter) {
    var obj = objectWithShapeOf();
    setter(obj);
    return obj;
  }
  function unsafePropsOf() {
    return new ReactProps();
  }
  function unsafePropsBy(setter) {
    var $receiver = unsafePropsOf();
    setter($receiver);
    return $receiver;
  }
  function propsBy(factory, setter) {
    var $receiver = factory();
    setter($receiver);
    return $receiver;
  }
  function propSetterOf$lambda(closure$factory) {
    return function (setter) {
      var $receiver = closure$factory();
      setter($receiver);
      return $receiver;
    };
  }
  function propSetterOf(factory) {
    return propSetterOf$lambda(factory);
  }
  function toPropSetter$lambda(this$toPropSetter) {
    return function (setter) {
      var $receiver = this$toPropSetter();
      setter($receiver);
      return $receiver;
    };
  }
  function toPropSetter($receiver) {
    return toPropSetter$lambda($receiver);
  }
  function PropTypeBuilder() {
    this.restrictions = Kotlin.kotlin.collections.HashMap_init_q3lmfv$();
  }
  PropTypeBuilder.prototype.memberOf_0 = function (selector) {
    var tmp$;
    var regex = Regex('it\\.(.*);');
    tmp$ = regex.find_905azu$(selector.toString());
    if (tmp$ == null) {
      throw new Error_0("Defina a sele\xE7\xE3o do membro usando uma express\xE3o simples com o par\xE2metro 'it'.");
    }
    var result = tmp$;
    return result.groupValues.get_za3lpa$(1);
  };
  PropTypeBuilder.prototype.required_wdl6uc$ = function (selector) {
    var memberName = this.memberOf_0(selector);
    var restriction = $module$react.PropTypes.any.isRequired;
    this.restrictions.put_xwzc9p$(memberName, restriction);
  };
  PropTypeBuilder.prototype.applyTo_6ov252$ = function (factory) {
    var tmp$_0;
    var props = objectWithShapeOf();
    tmp$_0 = this.restrictions.entries.iterator();
    while (tmp$_0.hasNext()) {
      var tmp$ = tmp$_0.next();
      var key = tmp$.key;
      var value = tmp$.value;
      props.set(key, value);
    }
    factory.propTypes = props;
  };
  PropTypeBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'PropTypeBuilder',
    interfaces: []
  };
  function propTypesOf(factory, configure) {
    var propTypeBuilder = new PropTypeBuilder();
    configure(propTypeBuilder);
    propTypeBuilder.applyTo_6ov252$(factory);
  }
  function createElement_0(function_0, props, children) {
    if (props === void 0)
      props = null;
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [function_0, props != null ? props.json : null].concat(children));
  }
  function createElement_1(elementName, props, children) {
    if (props === void 0)
      props = null;
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [elementName, props != null ? props.json : null].concat(children));
  }
  function createElement(componentType, props, children) {
    var tmp$;
    return (tmp$ = $module$react).createElement.apply(tmp$, [componentType, props != null ? props.json : null].concat(children));
  }
  function createElement_2(componentType, props, children) {
    return createElement(get_js(componentType), props, children.slice());
  }
  function ReactChildren() {
  }
  ReactChildren.$metadata$ = {
    kind: Kotlin.Kind.INTERFACE,
    simpleName: 'ReactChildren',
    interfaces: []
  };
  function isArray($receiver) {
    return Array.isArray($receiver);
  }
  function isString($receiver) {
    return typeof $receiver === 'string';
  }
  function isNumber($receiver) {
    return typeof $receiver === 'number';
  }
  function isElement($receiver) {
    return typeof $receiver === 'object';
  }
  function toArray($receiver) {
    return isArray($receiver) ? $receiver : [$receiver];
  }
  function asString($receiver) {
    return $receiver;
  }
  function asNumber($receiver) {
    return $receiver;
  }
  function asElements($receiver) {
    return $receiver;
  }
  function asReactElement($receiver) {
    if ($receiver == null)
      return null;
    if (isArray($receiver)) {
      throw new OnlyOneChildIsAllowedError($receiver);
    }
    return $receiver;
  }
  function OnlyOneChildIsAllowedError(children) {
    Throwable.call(this);
    this.message_1w6vbr$_0 = 'Too many children to return as a single child';
    this.cause_1w6vbr$_0 = null;
    this.children = children;
    Kotlin.captureStack(Throwable, this);
    this.name = 'OnlyOneChildIsAllowedError';
  }
  Object.defineProperty(OnlyOneChildIsAllowedError.prototype, 'message', {
    get: function () {
      return this.message_1w6vbr$_0;
    }
  });
  Object.defineProperty(OnlyOneChildIsAllowedError.prototype, 'cause', {
    get: function () {
      return this.cause_1w6vbr$_0;
    }
  });
  OnlyOneChildIsAllowedError.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'OnlyOneChildIsAllowedError',
    interfaces: [Throwable]
  };
  function concat($receiver, elements) {
    var tmp$;
    if ($receiver == null) {
      return all(elements.slice());
    }
    if (isArray($receiver)) {
      return reactChildren((Array.isArray(tmp$ = $receiver) ? tmp$ : Kotlin.throwCCE()).concat(elements));
    }
    return reactChildren([asReactElement($receiver)].concat(elements));
  }
  function reactChildren(children) {
    if (children.length > 1) {
      return children;
    }
    if (children.length === 1) {
      return children[0];
    }
    return null;
  }
  function reactChildren_0(element) {
    return element;
  }
  function text_0(something) {
    return something;
  }
  function all(elements) {
    return elements;
  }
  function ReactProps(json_0) {
    if (json_0 === void 0)
      json_0 = json([]);
    this.json = json_0;
    this.jsonProperty = new JsonPropertyDelegate(this.json);
    this.key$delegate = this.jsonProperty;
    this.ref$delegate = this.jsonProperty;
    this.refBy$delegate = this.jsonProperty_61zpoe$('ref');
    this.children$delegate = this.jsonProperty;
  }
  Object.defineProperty(ReactProps.prototype, 'key', {
    get: function () {
      return this.key$delegate.getValue_lrcp0p$(this, new Kotlin.PropertyMetadata('key'));
    },
    set: function (key) {
      this.key$delegate.setValue_9rddgb$(this, new Kotlin.PropertyMetadata('key'), key);
    }
  });
  Object.defineProperty(ReactProps.prototype, 'ref', {
    get: function () {
      return this.ref$delegate.getValue_lrcp0p$(this, new Kotlin.PropertyMetadata('ref'));
    },
    set: function (ref) {
      this.ref$delegate.setValue_9rddgb$(this, new Kotlin.PropertyMetadata('ref'), ref);
    }
  });
  Object.defineProperty(ReactProps.prototype, 'refBy', {
    get: function () {
      return this.refBy$delegate.getValue_lrcp0p$(this, new Kotlin.PropertyMetadata('refBy'));
    },
    set: function (refBy) {
      this.refBy$delegate.setValue_9rddgb$(this, new Kotlin.PropertyMetadata('refBy'), refBy);
    }
  });
  Object.defineProperty(ReactProps.prototype, 'children', {
    get: function () {
      return this.children$delegate.getValue_lrcp0p$(this, new Kotlin.PropertyMetadata('children'));
    },
    set: function (children) {
      this.children$delegate.setValue_9rddgb$(this, new Kotlin.PropertyMetadata('children'), children);
    }
  });
  ReactProps.prototype.addChild_aecpp9$ = function (child) {
    var tmp$, tmp$_0;
    this.children = (tmp$_0 = (tmp$ = this.children) != null ? concat(tmp$, [child]) : null) != null ? tmp$_0 : reactChildren_0(child);
  };
  ReactProps.prototype.spreadTo_ps78fa$ = function (other, except) {
    if (except === void 0)
      except = [];
    var json_0 = this.json;
    var otherJson = other.json;
    for (var key in json_0) {
      if (except.indexOf(key) >= 0)
        continue;
      otherJson[key] = json_0[key];
    }
  };
  ReactProps.prototype.jsonProperty_61zpoe$ = function (fieldName) {
    return new JsonPropertyDelegate(this.json, fieldName);
  };
  ReactProps.prototype.unaryPlus_wsm53i$ = function ($receiver) {
    this.addChild_aecpp9$($receiver);
  };
  ReactProps.prototype.unaryPlus_5cw0du$ = function ($receiver) {
    this.addChild_aecpp9$(text_0($receiver));
  };
  ReactProps.prototype.unaryPlus_6eqio1$ = function ($receiver) {
    if ($receiver == null) {
      this.addChild_aecpp9$(null);
    }
     else {
      this.addChild_aecpp9$(all($receiver.slice()));
    }
  };
  ReactProps.prototype.get = function (propertyName) {
    return this.json[propertyName];
  };
  ReactProps.prototype.set = function (propertyName, value) {
    return this.json[propertyName] = value;
  };
  ReactProps.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'ReactProps',
    interfaces: []
  };
  function StatelessRenderer(factory) {
    if (factory === void 0)
      factory = StatelessRenderer_init$lambda;
    var tmp$;
    this.renderer_nk0uia$_0 = makeNamedComponent((tmp$ = Kotlin.getKClassFromExpression(this).simpleName) != null ? tmp$ : Kotlin.throwNPE(), factory, Kotlin.getCallableRef('render', function ($receiver, props) {
      return $receiver.render_yhfe8q$(props);
    }.bind(null, this)));
  }
  StatelessRenderer.prototype.invoke_oswy3$ = function (setter) {
    return this.renderer_nk0uia$_0(setter);
  };
  function StatelessRenderer_init$lambda() {
    return unsafePropsOf();
  }
  StatelessRenderer.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'StatelessRenderer',
    interfaces: []
  };
  function StyleBuilder(initialClasses) {
    this.classes = Kotlin.kotlin.collections.ArrayList_init_ww73n8$();
    var tmp$;
    for (tmp$ = 0; tmp$ !== initialClasses.length; ++tmp$) {
      var element = initialClasses[tmp$];
      this.add_pdl1vj$(element);
    }
  }
  StyleBuilder.prototype.add_pdl1vj$ = function (className) {
    if (className != null) {
      this.classes.add_11rb$(className);
    }
    return this;
  };
  StyleBuilder.prototype.add_154u1l$ = function (className, predicate) {
    if (Kotlin.equals(predicate, true)) {
      this.add_pdl1vj$(className);
    }
    return this;
  };
  StyleBuilder.prototype.toString = function () {
    var $receiver = this.classes;
    return joinToString(Kotlin.kotlin.collections.copyToArray($receiver), ' ');
  };
  StyleBuilder.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: 'StyleBuilder',
    interfaces: []
  };
  var package$kodando = _.kodando || (_.kodando = {});
  var package$react = package$kodando.react || (package$kodando.react = {});
  package$react.ComponentBuilder_init_j7rr0l$ = ComponentBuilder_init;
  package$react.ComponentBuilder = ComponentBuilder;
  package$react.JsonPropertyDelegate = JsonPropertyDelegate;
  package$react.makeNamedComponent_wim61n$ = makeNamedComponent;
  package$react.objectWithShapeOf_287e2$ = objectWithShapeOf;
  package$react.objectWithShapeBy_7qq44f$ = objectWithShapeBy;
  package$react.unsafePropsOf_ytx7zy$ = unsafePropsOf;
  package$react.unsafePropsBy_qa7hpv$ = unsafePropsBy;
  package$react.propsBy = propsBy;
  package$react.propSetterOf = propSetterOf;
  package$react.toPropSetter = toPropSetter;
  package$react.PropTypeBuilder = PropTypeBuilder;
  package$react.propTypesOf_gj2b02$ = propTypesOf;
  package$react.reactCreateStatelessElement = createElement_0;
  package$react.reactCreateDOMElement = createElement_1;
  package$react.reactCreateComponent = createElement;
  package$react.reactCreateKClassComponent = createElement_2;
  package$react.ReactChildren = ReactChildren;
  package$react.reactChildrenIsArray = isArray;
  package$react.reactChildrenIsString = isString;
  package$react.reactChildrenIsNumber = isNumber;
  package$react.reactChildrenIsElement = isElement;
  package$react.reactChildrenToArray = toArray;
  package$react.reactChildrenAsString = asString;
  package$react.reactChildrenAsNumber = asNumber;
  package$react.reactChildrenAsElements = asElements;
  package$react.reactChildrenAsReactElement = asReactElement;
  package$react.OnlyOneChildIsAllowedError = OnlyOneChildIsAllowedError;
  package$react.concatReactChildrenWithElements = concat;
  package$react.reactChildrenFromArray = reactChildren;
  package$react.reactChildrenFromElement = reactChildren_0;
  package$react.text_pdl1vj$ = text_0;
  package$react.all_lmgdju$ = all;
  package$react.ReactProps = ReactProps;
  package$react.StatelessRenderer = StatelessRenderer;
  var package$util = package$react.util || (package$react.util = {});
  package$util.StyleBuilder = StyleBuilder;
  Kotlin.defineModule('kodando-react', _);
  return _;
}));

//@ sourceMappingURL=kodando-react.js.map
