/*
 * Decompiled with CFR 0.152.
 */
package br.com.esign.google.geocode.model;

import br.com.esign.google.geocode.model.AddressComponent;
import br.com.esign.google.geocode.model.AddressComponentType;
import br.com.esign.google.geocode.model.GeocodeResponseStatus;
import br.com.esign.google.geocode.model.Geometry;
import br.com.esign.google.geocode.model.Result;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Optional;

@JsonIgnoreProperties(ignoreUnknown=true)
public class GeocodeResponse {
    private final List<Result> results;
    private final String status;
    @JsonProperty(value="error_message")
    private final String errorMessage;
    @JsonIgnore
    private int index = 0;

    public GeocodeResponse() {
        this(null, null, null);
    }

    public GeocodeResponse(List<Result> results, String status, String errorMessage) {
        this.results = results;
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public List<Result> getResults() {
        return this.results;
    }

    public String getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public AddressComponent getAddressComponentByType(AddressComponentType t) {
        return this.getAddressComponentByType(this.index, t);
    }

    public AddressComponent getAddressComponentByType(int i, AddressComponentType t) {
        AddressComponent addressComponent;
        try {
            Optional<AddressComponent> optional = this.getResult(i).getAddressComponents().stream().filter(a -> a.getTypes().contains(t.getValue())).findFirst();
            addressComponent = optional.isPresent() ? optional.get() : null;
        }
        catch (NullPointerException e) {
            addressComponent = null;
        }
        return addressComponent;
    }

    @JsonIgnore
    public String getSublocalityLongName() {
        return this.getSublocalityLongName(this.index);
    }

    public String getSublocalityLongName(int i) {
        AddressComponent addressComponent = this.getAddressComponentByType(i, AddressComponentType.SUBLOCALITY);
        return addressComponent == null ? null : addressComponent.getLongName();
    }

    @JsonIgnore
    public String getNeighborhoodLongName() {
        return this.getNeighborhoodLongName(this.index);
    }

    public String getNeighborhoodLongName(int i) {
        AddressComponent addressComponent = this.getAddressComponentByType(i, AddressComponentType.NEIGHBORHOOD);
        return addressComponent == null ? null : addressComponent.getLongName();
    }

    @JsonIgnore
    public String getLocalityLongName() {
        return this.getLocalityLongName(this.index);
    }

    public String getLocalityLongName(int i) {
        AddressComponent addressComponent = this.getAddressComponentByType(i, AddressComponentType.LOCALITY);
        return addressComponent == null ? null : addressComponent.getLongName();
    }

    @JsonIgnore
    public String getAdministrativeAreaLevel2LongName() {
        return this.getAdministrativeAreaLevel2LongName(this.index);
    }

    public String getAdministrativeAreaLevel2LongName(int i) {
        AddressComponent addressComponent = this.getAddressComponentByType(i, AddressComponentType.ADMINISTRATIVE_AREA_LEVEL_2);
        return addressComponent == null ? null : addressComponent.getLongName();
    }

    @JsonIgnore
    public String getAdministrativeAreaLevel1LongName() {
        return this.getAdministrativeAreaLevel1LongName(this.index);
    }

    public String getAdministrativeAreaLevel1LongName(int i) {
        AddressComponent addressComponent = this.getAddressComponentByType(i, AddressComponentType.ADMINISTRATIVE_AREA_LEVEL_1);
        return addressComponent == null ? null : addressComponent.getLongName();
    }

    @JsonIgnore
    public String getCountryShortName() {
        return this.getCountryShortName(this.index);
    }

    public String getCountryShortName(int i) {
        AddressComponent addressComponent = this.getAddressComponentByType(i, AddressComponentType.COUNTRY);
        return addressComponent == null ? null : addressComponent.getShortName();
    }

    @JsonIgnore
    public String getFormattedAddress() {
        return this.getFormattedAddress(this.index);
    }

    public String getFormattedAddress(int i) {
        String formattedAddress;
        try {
            formattedAddress = this.getResult(i).getFormattedAddress();
        }
        catch (NullPointerException e) {
            formattedAddress = null;
        }
        return formattedAddress;
    }

    @JsonIgnore
    public Geometry getGeometry() {
        return this.getGeometry(this.index);
    }

    public Geometry getGeometry(int i) {
        Geometry geometry;
        try {
            geometry = this.getResult(i).getGeometry();
        }
        catch (NullPointerException e) {
            geometry = null;
        }
        return geometry;
    }

    @JsonIgnore
    public boolean isStatusOK() {
        return GeocodeResponseStatus.OK.getValue().equals(this.getStatus());
    }

    public Result getResult(int i) {
        Result result;
        try {
            result = this.getResults().get(i);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            result = null;
        }
        return result;
    }
}

