/*
 * Decompiled with CFR 0.152.
 */
package br.com.esign.google.geocode;

import br.com.esign.google.geocode.GoogleGeocodeLanguage;
import br.com.esign.google.geocode.model.GeocodeResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;

public class GoogleGeocode {
    private String languageCode = System.getProperty("google.geocode.language.code");
    private String apiKey;
    private String address;
    private String lat;
    private String lng;
    private boolean reverse;

    public GoogleGeocode(String apiKey, String address) {
        this.apiKey = apiKey;
        this.address = address;
    }

    public GoogleGeocode(String apiKey, String lat, String lng) {
        this.apiKey = apiKey;
        this.lat = lat;
        this.lng = lng;
        this.reverse = true;
    }

    public void setLanguage(GoogleGeocodeLanguage language) {
        this.languageCode = language.getCode();
    }

    public String getJsonString() throws IOException {
        URL url = new URL(this.getHttpUrl());
        URLConnection conn = url.openConnection();
        return this.getJsonString(conn.getInputStream());
    }

    private String getHttpUrl() throws IOException {
        StringBuilder httpUrl = new StringBuilder("https://maps.googleapis.com/maps/api/geocode/json?sensor=false&");
        if (this.languageCode != null && !this.languageCode.isEmpty()) {
            httpUrl.append("language=").append(this.languageCode).append("&");
        }
        httpUrl.append("key=").append(this.apiKey).append("&");
        if (this.reverse) {
            httpUrl.append("latlng=").append(this.lat).append(",").append(this.lng);
        } else {
            httpUrl.append("address=").append(URLEncoder.encode(this.address, "utf-8"));
        }
        return httpUrl.toString();
    }

    private String getJsonString(InputStream inputStream) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new InputStreamReader(inputStream, "utf-8"));
        StringBuilder out = new StringBuilder();
        while ((line = in.readLine()) != null) {
            out.append(line);
        }
        return out.toString();
    }

    public GeocodeResponse getResponseObject() throws IOException {
        String json = this.getJsonString();
        ObjectMapper mapper = new ObjectMapper();
        return (GeocodeResponse)mapper.readValue(json, GeocodeResponse.class);
    }
}

