/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.server.factory;

public enum Status {
    REQUEST_OK(100),
    TRANSACTION_IN_PROGRESS(110),
    REGISTRATION_VALID(120),
    CERTIFICATE_VALID(130),
    CSR_VALID(131),
    REVOCATION_ACCEPTED(132),
    SIGNATURE_VALID(140),
    REQUEST_MISSING_PARAM(200),
    REQUEST_WRONG_PARAM(201),
    REQUEST_WRONG_LENGTH(202),
    REQUEST_BAD_FORMAT(203),
    REQUEST_BAD_PROFILE(204),
    REQUEST_BAD_DATA(205),
    REQUEST_DUPLICATED(206),
    ACCOUNT_NO_BANDWIDTH(210),
    ACCOUNT_MAX_TRIES(211),
    ACCESS_NOT_AUTHORIZED(220),
    ACCESS_NO_HANDSHAKE(221),
    ACCESS_NO_SPECIFIED(221),
    NETWORK_ERROR(300),
    TRANSACTION_EXPIRED(301),
    TRANSACTION_NOT_FOUND(310),
    IDENTIFIER_NOT_FOUND(311),
    SERVICE_NOT_FOUND(312),
    MOBILE_SIGNATURE_ERROR(320),
    MOBILE_CERTIFICATE_ERROR(321),
    USER_CANCELED(400),
    MESSAGE_BAD_INTEGRITY(410),
    MESSAGE_BAD_AUTHENTICATION(411),
    MESSAGE_BAD_ENCRYPTION(412),
    MESSAGE_BAD_ENCODING(413),
    MESSAGE_WRONG_VERSION(420),
    MESSAGE_MISSING_KEY(421),
    MESSAGE_UNEXPECTED_KEY(422),
    MESSAGE_UNEXPECTED(423),
    KEY_EXPIRED(424),
    KEY_REJECTED(425),
    MESSAGE_NOT_FOUND(430),
    USER_NOT_FOUND(431),
    INTERNAL_ERROR(440),
    SERVICE_CANT_ACTIVATE(450),
    SERVICE_CANT_USE(451),
    SERVICE_WAS_ACTIVATED(452),
    PLATFORM_NOT_FOUND(500),
    TOKEN_WRONG(501),
    IDENTIFIER_INVALID(502),
    IDENTIFIER_DUPLICATED(503),
    CERTIFICATE_INVALID(600),
    CSR_INVALID(601),
    CRL_INVALID(602),
    CERTIFICATE_MALFORMED(603),
    CERTIFICATE_REVOKED(604),
    CERTIFICATE_EXPIRED(605),
    CERTIFICATE_NOT_IN_EFFECT(606),
    CERTIFICATE_BLOCKED(607),
    CERTIFICATE_NOT_TRUSTED(608),
    KEY_SIZE_INVALID(609),
    CERTIFICATE_NOT_FOUND(620),
    CHAIN_NOT_FOUND(621),
    KEY_NOT_FOUND(622),
    CARD_ERROR(630),
    CARD_PIN_BLOCKED(631),
    CARD_BLOCKED(632),
    CARD_NOT_PRESENT(633),
    PIN_WRONG(640),
    CERTIFICATE_CANT_REVOKE(650),
    CERTIFICATE_DUPLICATED(660),
    CERTIFICATE_WRONG_SUBJECT(661),
    KEY_MISMATCH(662),
    SIGNATURE_INVALID(700),
    TEMPLATE_NOT_FOUND(710),
    DOCUMENT_NOT_FOUND(711),
    WRONG_DOCUMENT_HASH(712),
    WRONG_DOCUMENT_TYPE(713),
    XMLDSIG_EMPTY_ELEMENT_LIST(720),
    XMLDSIG_ELEMENTS_WITHOUT_ATRIBUTE_ID(721),
    XMLDSIG_SAME_ID_FOR_MULTIPLE_ELEMENTS(722),
    XMLDSIG_NO_ELEMENT_FOUND(723);

    private int code;

    private Status(int code) {
        this.code = code;
    }

    public int getCode() {
        return this.code;
    }

    public boolean isSuccess() {
        return !this.isError();
    }

    public boolean isError() {
        return this.code >= 200;
    }

    public static Status getByCode(int code) {
        Status[] all;
        for (Status status : all = Status.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        return null;
    }
}

