package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

/**
 * Known chains are:
 * <ul>
 * <li>ICPBR
 * <li>JUS
 * <li>RFB
 * </ul>
 */
@XmlType(name = "TrustChain")
@XmlEnum
public enum TrustChainType implements Serializable {

    @XmlEnumValue("ICPBR")
    ICPBR("ICPBR"),
    @XmlEnumValue("JUS")
    JUS("JUS"),
    @XmlEnumValue("RFB")
    RFB("RFB");
    
    private final String value;

    TrustChainType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static TrustChainType fromValue(String v) {
        for (TrustChainType c: TrustChainType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
