package br.com.esec.icpm.server.ws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

import org.w3c.dom.Element;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlSeeAlso({StringType.class, DateType.class, IntegerType.class, DoubleType.class})
@XmlType(name = "TemplateType", propOrder = {
    "parameters"
})
public class TemplateType implements Serializable {


	private static final long serialVersionUID = 1L;
	
	@XmlAttribute(name = "TemplateId", required=true)
	protected Long templateId;
	
	@XmlElementRef
	protected List<TemplateDataType> parameters;
	
	
	public Long getTemplateId() {
		return templateId;
	}
	
	public void setTemplateId(Long templateId) {
		this.templateId = templateId;
	}
	
	/**
     * Gets the value of the any property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the any property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getParameters().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link Element }
     * {@link Object }
     * 
     * 
     */
	public List<TemplateDataType> getParameters() {
		 if (parameters == null) {
			 parameters = new ArrayList<TemplateDataType>();
        }
        return this.parameters;
	}
	
	public void setParameters(List<TemplateDataType> parameters) {
		this.parameters = parameters;
	}
}
