package br.com.esec.icpm.server.ws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

/**
 * Provide stardands options for XMLDsig, CAdES, XAdES and ADOBEPDF signatures 
 * 
 *
 * @author Cristiano Cristo
 * @version $Id: $Id
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlSeeAlso({
	ElementsIdXmldsigOptionType.class,
	AttributeIdNameXmldsigOptionType.class,
	ElementsNameXmldsigOptionType.class,
	AddSubjectNameXmldsigOptionType.class,
	AddKeyValXmldsigOptionType.class,
	MultipleSignaturesXmldsigOptionType.class
})
@XmlType(name = "SignatureStandardOptionsType", propOrder = {
	    "signatureStandardOptions"
})
public class SignatureStandardOptionsType implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Signature Options
	 * <p>
	 * <b> Ps: nowadays is only used for XMLDsig signatures.
	 * <p>
	 * Mandatory: No
	 */
	@XmlElements(value = { 
		@XmlElement(name = "ElementsId", type = ElementsIdXmldsigOptionType.class),
		@XmlElement(name = "AttributeIdName", type = AttributeIdNameXmldsigOptionType.class),
		@XmlElement(name = "ElementsName", type = ElementsNameXmldsigOptionType.class),
		@XmlElement(name = "AddSubjectName", type = AddSubjectNameXmldsigOptionType.class),
		@XmlElement(name = "AddKeyVal", type = AddKeyValXmldsigOptionType.class),
		@XmlElement(name = "MultipleSignatures", type = MultipleSignaturesXmldsigOptionType.class),
	})
	private List<SignatureStandardOptionType> signatureStandardOptions;

	public static SignatureStandardOptionsType of(SignatureStandardOptionType... options) {
		SignatureStandardOptionsType newInstance = new SignatureStandardOptionsType();
		for (SignatureStandardOptionType o : options) {
			newInstance.add(o);
		}
		return newInstance;
	}

	public void add(SignatureStandardOptionType option) {
		if (signatureStandardOptions == null) {
			signatureStandardOptions = new ArrayList<SignatureStandardOptionType>();
		}
		signatureStandardOptions.add(option);
	}

	@SuppressWarnings("unchecked")
	public List<String> getElementsId() {
		if (signatureStandardOptions != null) {
			for (Object f : signatureStandardOptions) {
				if (f instanceof ElementsIdXmldsigOptionType) {
					return (List<String>) ((SignatureStandardOptionType) f).getValue();
				}
			}
		}
		return null;
	}
	
	@SuppressWarnings("unchecked")
	public List<String> getElementsName() {
		if (signatureStandardOptions != null) {
			for (Object f : signatureStandardOptions) {
				if (f instanceof ElementsNameXmldsigOptionType) {
					return (List<String>) ((SignatureStandardOptionType) f).getValue();
				}
			}
		}
		return null;
	}

	public String getAttributeIdName() {
		if (signatureStandardOptions != null) {
			for (Object f : signatureStandardOptions) {
				if (f instanceof AttributeIdNameXmldsigOptionType) {
					return (String) ((SignatureStandardOptionType) f).getValue();
				}
			}
		}
		return null;
	}
	
	public Boolean getAddSubjectName() {
		if (signatureStandardOptions != null) {
			for (Object f : signatureStandardOptions) {
				if (f instanceof AddSubjectNameXmldsigOptionType) {
					return (Boolean) ((SignatureStandardOptionType) f).getValue();
				}
			}
		}
		return null;
	}
	
	public Boolean getAddKeyVal() {
		if (signatureStandardOptions != null) {
			for (Object f : signatureStandardOptions) {
				if (f instanceof AddKeyValXmldsigOptionType) {
					return (Boolean) ((SignatureStandardOptionType) f).getValue();
				}
			}
		}
		return null;
	}
	
	public Boolean getMultipleSignatures() {
		if (signatureStandardOptions != null) {
			for (Object f : signatureStandardOptions) {
				if (f instanceof MultipleSignaturesXmldsigOptionType) {
					return (Boolean) ((SignatureStandardOptionType) f).getValue();
				}
			}
		}
		return null;
	}
	
	public boolean isEmpty(){
		return signatureStandardOptions.isEmpty();
	}

}
