/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * Two messaging types are possible:
 * <ul>
 * <li>PERSON mode
 * <li>COMPANY mode
 * </ul>
 */
@XmlType(name = "OwnerType")
@XmlEnum
public enum OwnerType implements Serializable {

    @XmlEnumValue("PERSON")
    PERSON("PERSON"),
    @XmlEnumValue("COMPANY")
    COMPANY("COMPANY");
    
    private final String value;

    OwnerType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static OwnerType fromValue(String v) {
        for (OwnerType c: OwnerType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
