package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Inform if the XML will suffer a transformation to allow multiple signatures
 * 
 * @author ccristo
 * @category XMLDsig
 * @version $Id: $Id
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MultipleSignaturesXmldsigOptionType")
public class MultipleSignaturesXmldsigOptionType implements SignatureStandardOptionType, Serializable {

	private static final long serialVersionUID = -987941206521730122L;

	@XmlAttribute(name = "value", required = true)
	private Boolean value;

	public MultipleSignaturesXmldsigOptionType(Boolean value) {
		this.value = value;
	}
	
	public MultipleSignaturesXmldsigOptionType() {
		
	}

	public Boolean getValue() {
		return value;
	}
	
	public void setValue(Boolean value) {
		this.value = value;
	}
	

}
