package br.com.esec.icpm.server.ws;

import java.io.Serializable;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Elements name list of attributes to be signed
 * <p>
 * <b>Obs: Used in conjunction with {@link AttributeIdNameXmldsigOptionType}</b>
 * 
 * @author ccristo
 * @category XMLDsig
 * @version $Id: $Id
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ElementsNameXmldsigOptionType")
public class ElementsNameXmldsigOptionType implements SignatureStandardOptionType, Serializable {

	private static final long serialVersionUID = -987941206521730122L;

	@XmlAttribute(name = "value", required = true)
	private List<String> value;

	public ElementsNameXmldsigOptionType(List<String> value) {
		this.value = value;
	}
	
	public ElementsNameXmldsigOptionType() {
		
	}

	public List<String> getValue() {
		return value;
	}
	
	public void setValue(List<String> value) {
		this.value = value;
	}
	

}
