package br.com.esec.icpm.server.ws;

import java.io.Serializable;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Id list for elements to be signed
 * <p>
 * <b>Obs: Can't be used in conjunction with {@link AttributeIdNameXmldsigOptionType}</b>
 * 
 * @author ccristo
 * @category XMLDsig
 * @version $Id: $Id
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ElementsIdXmldsigOptionType")
public class ElementsIdXmldsigOptionType implements SignatureStandardOptionType, Serializable {

	private static final long serialVersionUID = -987941206521730122L;

	@XmlAttribute(name = "value", required = true)
	private List<String> value;

	public ElementsIdXmldsigOptionType(List<String> value) {
		this.value = value;
	}
	
	public ElementsIdXmldsigOptionType() {
	}

	public List<String> getValue() {
		return value;
	}
	
	public void setValue(List<String> value) {
		this.value = value;
	}

}
