/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * Two messaging modes are possible:
 * <ul>
 * <li>RSA mode
 * <li>ECC mode
 * </ul>
 */
@XmlType(name = "SignatureModeType")
@XmlEnum
public enum AlgorithmType implements Serializable {

    @XmlEnumValue("RSA")
    RSA("RSA"),
    @XmlEnumValue("ECC")
    ECC("ECC");
    private final String value;

    AlgorithmType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static AlgorithmType fromValue(String v) {
        for (AlgorithmType c: AlgorithmType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

    public boolean isEcc() {
		return ECC == this; 
	}
    
    public boolean isRsa() {
    	return RSA == this; 
    }
}
