package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

/**
 * Add key value to the XMLDsig signature
 * 
 * @author ccristo
 * @category XMLDsig
 * @version $Id: $Id
 *
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AddKeyValXmldsigOptionType")
public class AddKeyValXmldsigOptionType implements SignatureStandardOptionType, Serializable {

	private static final long serialVersionUID = -987941206521730122L;

	@XmlAttribute(name = "value", required = true)
	private Boolean value;

	public AddKeyValXmldsigOptionType(Boolean value) {
		this.value = value;
	}
	
	public AddKeyValXmldsigOptionType() {
		
	}

	public Boolean getValue() {
		return value;
	}
	
	public void setValue(Boolean value) {
		this.value = value;
	}
	

}
