/**
 * @see UC.01
 */
package br.com.esec.icpm.server.factory;

import java.io.IOException;
import java.util.Properties;

import br.com.esec.icpm.server.ws.StatusType;


/**
 * This class is responsible for generate all the status and error messages provided by the server. 
 * It's always in sync with the FaultCode class.
 */
public class StatusTypeFactory {

	private static final String DETAILS_FILE_NAME = "statusCodeDetails.properties";

	private static Properties detailsProps;

	/**
	 * Get the properties file that contains all the status message details
	 * @return Properties
	 */
	private static Properties getDetailsProps() {
		if (detailsProps == null) {
			try {
				detailsProps = new Properties();
				detailsProps.load(StatusTypeFactory.class
						.getResourceAsStream(DETAILS_FILE_NAME));
			} catch (IOException e) {
				throw new IllegalStateException(e);
			}
		}
		return detailsProps;
	}

	public static StatusType create(Status status) {
		return create(status,(Object[])null);
	}
	
	/**
	 * Create a StatusType object
	 * 
	 * @param status status
	 * @param args args
	 * @return status type
	 */
	public static StatusType create(Status status, Object... args) {
		String detail = getDetailsProps().getProperty(String.valueOf(status.getCode()));
		if (args != null && args.length > 0) {
			detail = String.format(detail, args);
		}
		StatusType s = new StatusType();
		s.setStatusDetail(detail);
		s.setStatusCode(status.getCode());
		s.setStatusMessage(status.name());
		return s;
	}
}
