/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.server.factory;

import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.ws.StatusType;
import java.io.IOException;
import java.util.Properties;

public class StatusTypeFactory {
    private static final String DETAILS_FILE_NAME = "statusCodeDetails.properties";
    private static Properties detailsProps;

    private static Properties getDetailsProps() {
        if (detailsProps == null) {
            try {
                detailsProps = new Properties();
                detailsProps.load(StatusTypeFactory.class.getResourceAsStream(DETAILS_FILE_NAME));
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return detailsProps;
    }

    public static StatusType create(Status status) {
        return StatusTypeFactory.create(status, null);
    }

    public static StatusType create(Status status, Object ... args) {
        String detail = StatusTypeFactory.getDetailsProps().getProperty(String.valueOf(status.getCode()));
        if (args != null && args.length > 0) {
            detail = String.format(detail, args);
        }
        StatusType s = new StatusType();
        s.setStatusDetail(detail);
        s.setStatusCode(status.getCode());
        s.setStatusMessage(status.name());
        return s;
    }
}

