package br.com.esec.icpm.server.ws.additionalservice.activator;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "ActivationStatusType")
@XmlEnum
public enum ActivationStatusType {

	@XmlEnumValue("SUCCESS")
	SUCCESS("SUCCESS"),
	
	@XmlEnumValue("ERROR")
	ERROR("ERROR");
	
	private String value;

	ActivationStatusType(String value) {
		this.value = value;
	}
	
	public String value() {
		return value;
	}
	
	public static ActivationStatusType fromValue(String value) {
		for (ActivationStatusType v : ActivationStatusType.values()) {
			if (v.value.equals(value)) {
				return v;
			}
		}
		throw new IllegalArgumentException(value);
	}
	
}
