/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * Describe the format of a generic notification response message
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "StatusRespType")
public class StatusRespType implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Current status of the transaction.
	 * <p>
	 * Mandatory: Yes
	 */
	@XmlElement(name = "Status", required = true)
	protected StatusType status;

	/**
	 * Gets the value of the status property.
	 * 
	 * @return possible object is {@link StatusType}
	 * 
	 */
	public StatusType getStatus() {
		return status;
	}

	/**
	 * Sets the value of the status property.
	 * 
	 * @param value
	 *            allowed object is {@link StatusType }
	 * 
	 */
	public void setStatus(StatusType value) {
		this.status = value;
	}

}