/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;

/**
 * This type specifies the enduser. The purpose is to specify uniquely the
 * enduser.
 */

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "MobileUserType")
public class MobileUserType implements Serializable {

	private static final long serialVersionUID = 1L;

	@Override
	public String toString() {
		return "MobileUserType [uniqueIdentifier=" + uniqueIdentifier + "]";
	}

	@XmlAttribute(name = "UniqueIdentifier", required = true)
	protected String uniqueIdentifier;

	/**
	 * Gets the value of the uniqueIdentifier property.
	 * 
	 * @return possible object is {@link String }
	 * 
	 */
	public String getUniqueIdentifier() {
		return uniqueIdentifier;
	}

	/**
	 * Sets the value of the uniqueIdentifier property.
	 * 
	 * @param value
	 *            allowed object is {@link String }
	 * 
	 */
	public void setUniqueIdentifier(String value) {
		this.uniqueIdentifier = value;
	}
}
