package br.com.esec.icpm.server.ws;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;


@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement
@XmlSeeAlso({ TrustChainCertificateFilterType.class, OwnerCertificateFilterType.class, AlgorithmCertificateFilterType.class, ForceHardwareFilterType.class })
@XmlType(name = "CertificateFiltersType", propOrder = {
	    "certificateFilters"
	})
public class CertificateFiltersType implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Filter the signature mode
	 * <p>
	 * Mandatory: No
	 */
	@XmlElements(value = { 
		@XmlElement(name = "TrustChain", type = TrustChainCertificateFilterType.class),
		@XmlElement(name = "OwnerCertificate", type = OwnerCertificateFilterType.class), 
		@XmlElement(name = "Algorithm", type = AlgorithmCertificateFilterType.class), 
		@XmlElement(name = "ForceHardware", type = ForceHardwareFilterType.class) 
	})
	private List<Object> certificateFilters;

	public static CertificateFiltersType create(CertificateFilterType... args) {
		CertificateFiltersType filters = new CertificateFiltersType();
		for (CertificateFilterType f : args) {
			filters.addFilter(f);
		}
		return filters;
	}

	public void addFilter(CertificateFilterType filter) {
		if (certificateFilters == null) {
			certificateFilters = new ArrayList<Object>();
		}
		certificateFilters.add(filter);
	}

	public AlgorithmType getAlgorithm() {
		if (certificateFilters != null) {
			for (Object f : certificateFilters) {
				if (f instanceof AlgorithmCertificateFilterType) {
					return (AlgorithmType) ((CertificateFilterType) f).getValue();
				}
			}
		}
		return null;
	}

	public OwnerType getOwnerType() {
		if (certificateFilters != null) {
			for (Object f : certificateFilters) {
				if (f instanceof OwnerCertificateFilterType) {
					return (OwnerType) ((CertificateFilterType) f).getValue();
				}
			}
		}
		return null;
	}

	public TrustChainType getTrustChain() {
		if (certificateFilters != null) {
			for (Object f : certificateFilters) {
				if (f instanceof TrustChainCertificateFilterType) {
					return (TrustChainType) ((CertificateFilterType) f).getValue();
				}
			}
		}
		return null;
	}
	
	public boolean getForceHardware() {
		if (certificateFilters != null) {
			for (Object f : certificateFilters) {
				if (f instanceof ForceHardwareFilterType) {
					return (Boolean) ((CertificateFilterType) f).getValue();
				}
			}
		}
		return false;
	}

}
