/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;

@XmlType(name = "AdditionalServiceType")
@XmlEnum
public enum AdditionalServiceType implements Serializable {

	@XmlEnumValue("dummy")
	DUMMY("dummy"),
	
	@XmlEnumValue("offlineSignature")
	OFFLINE_SIGNATURE("offlineSignature"),
	
	@XmlEnumValue("aetDriver")
	AET_DRIVER("aetDriver"),
	
	@XmlEnumValue("kaspersky")
	KASPERSKY("kaspersky");
	
	private final String value;

	AdditionalServiceType(String v) {
		value = v;
	}

	public String value() {
		return value;
	}

	public static AdditionalServiceType fromValue(String v) {
		for (AdditionalServiceType c : AdditionalServiceType.values()) {
			if (c.value.equals(v)) {
				return c;
			}
		}
		throw new IllegalArgumentException(v);
	}

}
