/*
 * Decompiled with CFR 0.152.
 */
package br.com.esec.icpm.server.ws;

import br.com.esec.icpm.server.factory.Status;
import br.com.esec.icpm.server.factory.StatusTypeFactory;
import br.com.esec.icpm.server.ws.StatusType;
import javax.xml.ws.WebFault;

@WebFault(name="FaultDetail")
public class ICPMException
extends Exception {
    private static final long serialVersionUID = 1L;
    private StatusType faultInfo;

    public String toString() {
        return "ICPMException [faultInfo=" + this.faultInfo + "]";
    }

    public ICPMException(StatusType faultInfo) {
        super(faultInfo.getStatusDetail());
        this.faultInfo = faultInfo;
    }

    public ICPMException(String message, StatusType faultInfo) {
        super(message);
        this.faultInfo = faultInfo;
    }

    public ICPMException(Throwable cause) {
        super(cause);
        this.faultInfo = StatusTypeFactory.create(Status.INTERNAL_ERROR);
        if (cause != null && cause.getMessage() != null) {
            this.faultInfo.setStatusDetail(cause.getMessage());
        }
    }

    public ICPMException(Throwable cause, StatusType faultInfo) {
        super(faultInfo.getStatusDetail(), cause);
        this.faultInfo = faultInfo;
    }

    public ICPMException(String message, Throwable cause, StatusType faultInfo) {
        super(message, cause);
        this.faultInfo = faultInfo;
    }

    public StatusType getFaultInfo() {
        return this.faultInfo;
    }

    public void setFaultInfo(StatusType faultInfo) {
        this.faultInfo = faultInfo;
    }
}

