/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws.additionalservice.activator;

import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebService;
import javax.jws.soap.SOAPBinding;
import javax.xml.namespace.QName;

import br.com.esec.icpm.server.ws.ICPMException;

@WebService(name = AdditionalServiceActivatorPortType.PORT_NAME, targetNamespace = Namespace.NAME)
@SOAPBinding(style = SOAPBinding.Style.RPC)
public interface AdditionalServiceActivatorPortType {

	String PORT_NAME = "AdditionalServiceActivatorPortType";
	String SERVICE_NAME = "AdditionalServiceActivatorService";
	QName QNAME = new QName(Namespace.NAME, SERVICE_NAME);

    @WebMethod(operationName = "Activate")
    public void activate(
    		@WebParam(name = "ActivateReq", partName = "ActivateReq")
    		ActivateReqType activateReq) throws ICPMException;

}
