package br.com.esec.icpm.server.ws.additionalservice.activator;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;

import br.com.esec.icpm.server.ws.AdditionalServiceType;
import br.com.esec.icpm.server.ws.MobileUserType;

@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "ActivateReqType", propOrder = { "mobileUser", "additionalService" })
public class ActivateReqType implements Serializable {

	private static final long serialVersionUID = 1L;

	/**
	 * Any identifier that allows the MSSP to contact enduser's mobile device.
	 * <p>
	 * Mandatory: Yes
	 */
	@XmlElement(name = "MobileUser", required = true)
	protected MobileUserType mobileUser;

	/**
	 * Additional services to enable in this transaction
	 * <p>
	 * Mandatory: No
	 */
	@XmlElement(name = "AdditionalService", required = true)
	protected AdditionalServiceType additionalService;

	public MobileUserType getMobileUser() {
		return mobileUser;
	}

	public void setMobileUser(MobileUserType mobileUser) {
		this.mobileUser = mobileUser;
	}

	public AdditionalServiceType getAdditionalService() {
		return additionalService;
	}

	public void setAdditionalService(AdditionalServiceType additionalService) {
		this.additionalService = additionalService;
	}

}
