/**
 * @see UC.01
 */
package br.com.esec.icpm.server.ws;

import java.io.Serializable;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;


/**
 * The StatusType indicates the status of a response. Therefore a mandatory status code of type is 
 * used as well as an optional message of type string and an optional element StatusDetail of type 
 * described below.
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "StatusType", propOrder = {
    "statusCode",
    "statusMessage",
    "statusDetail"
})
public class StatusType implements Serializable {
	
	private static final long serialVersionUID = 1L;

	@Override
	public String toString() {
		return "StatusType [statusCode=" + statusCode + ", statusMessage=" + statusMessage + "]";
	}

	@XmlElement(name = "StatusCode", required = true)
    protected int statusCode;
    @XmlElement(name = "StatusMessage")
    protected String statusMessage;
    @XmlElement(name = "StatusDetail")
    protected String statusDetail;

    /**
     * Gets the value of the statusCode property.
     * 
     * @return status code
     *     
     */
    public int getStatusCode() {
        return statusCode;
    }

    /**
     * Sets the value of the statusCode property.
     * 
     * @param statusCode status code
     *     
     */
    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    /**
     * Gets the value of the statusMessage property.
     * 
     * @return statusMessage
     *     
     */
    public String getStatusMessage() {
        return statusMessage;
    }

    /**
     * Sets the value of the statusMessage property.
     * 
     * @param statusMessage status message
     *     
     */
    public void setStatusMessage(String statusMessage) {
        this.statusMessage = statusMessage;
    }

    /**
     * Gets the value of the statusDetail property.
     * 
     * @return statusDetail
     *     
     */
    public String getStatusDetail() {
        return statusDetail;
    }

    /**
     * Sets the value of the statusDetail property.
     * 
     * @param statusDetail status detail
     *     
     */
    public void setStatusDetail(String statusDetail) {
        this.statusDetail = statusDetail;
    }

}
