package br.com.esec.icpm.libs.signature.response.handler.simple;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

import br.com.esec.icpm.libs.Server;
import br.com.esec.icpm.libs.signature.exceptions.SignatureException;
import br.com.esec.icpm.libs.signature.response.handler.BaseSignatureHandler;
import br.com.esec.icpm.libs.signature.response.handler.SignatureHandler;
import br.com.esec.icpm.mss.ws.SignatureRespType;

public abstract class BaseSimpleSignatureHandler extends BaseSignatureHandler {

	protected InputStream signature;
	protected int statusCode;
	protected String statusMessage;

	public BaseSimpleSignatureHandler(Server server, SignatureRespType response) {
		super(server, response.getTransactionId());
		
		try {
			if (response.getStatus() != null) {
				statusCode = response.getStatus().getStatusCode();
				statusMessage = response.getStatus().getStatusMessage();
				signature = parseSignature(statusCode, response.getSignature());
			}
		} catch (IOException e) {
			throw new IllegalStateException(e);
		}
	}

	public BaseSimpleSignatureHandler(Server server, long transactionId) {
		super(server, transactionId);
	}

	@Override
	public SignatureHandler save(OutputStream out) throws IOException, SignatureException {
		success();
		
		saveCades(out, signature);
		
		return this;
	}
	
	@Override
	public SignatureHandler saveAttached(OutputStream out0) throws IOException, SignatureException {
		// TODO Auto-generated method stub
		return null;
	}
	
	@Override
	public SignatureHandler saveAttached(InputStream in, OutputStream out) throws IOException, SignatureException {
		success();
		
		saveCades(in, out, signature);
		
		return this;
	}

	@Override
	public SignatureHandler success() throws SignatureException {
		validateStatus(transactionId, statusCode, statusMessage);
		return this;
	}

}