package br.com.esec.icpm.libs.signature.response.handler;

import java.util.concurrent.TimeoutException;

import br.com.esec.icpm.server.ws.ICPMException;

public interface SignatureAsynchHandler extends SignatureHandler {

	long DEFAULT_TIMEOUT = 60; // 60s
	
	SignatureAsynchHandler waitTo() throws ICPMException, InterruptedException, TimeoutException;

	SignatureAsynchHandler waitTo(long timeout) throws ICPMException, InterruptedException, TimeoutException;
	
	SignatureAsynchHandler addListener(Listener listener) throws ICPMException, InterruptedException, TimeoutException;

	public interface Listener {
		void onSuccess(SignatureAsynchHandler handler);
		void onFailed(Throwable e);
	}
	
}